/**
 *
 * @author iYondaime
 * @version 0.0.0
 *
 * Adds simple delegate to the mosaic
 *
 * last modified: 2011-05-24 9:25 AM
 */

if (! UIF) {
    throw new Error("UIF module not found");
}


(function () {

    var conf = {
        FOCUSED_CLASS : "focused",
        SHATTERED_CLASS: "shattered"    
    };

    // UIF.View's DELEGATE protocol
    this.onfocus = function (el) {addClass(el, conf.FOCUSED_CLASS);};


    this.onblur = function (el) {
        el.blur();
        removeClass(el, conf.FOCUSED_CLASS);
    };

    this.onenter = function (el) {
        var evt = document.createEvent("MouseEvents");
        evt.initMouseEvent("click", true, true, window,
            0, 0, 0, 0, 0, false, false, false, false, 0, null);
        el.dispatchEvent(evt);
    };


    // Gluable module
    this.onshatter = function () {
        addClass(this.glueElement, conf.SHATTERED_CLASS);
    };
    this.onglue = function () {
        removeClass(this.glueElement, conf.SHATTERED_CLASS);
    };


    // utils

    function hasClass(el, className) {
        return !! el.className.match(classRegExp(className));
    }

    function addClass(el, className) {
        if (! hasClass(el, className)) {
            el.className = (el.className + " " + className);    // trim
        }
    }

    function removeClass(el, className) {
        el.className = el.className.replace(
            classRegExp(className), ' ');    // trim
    }

    function classRegExp(className) {
        return new RegExp('(^|\\s)' + className + '(\\s|$)');
    }


}).call(UIF.Mosaic.prototype);
